﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// Current Logging facility for BMXNet.  This facility conforms to the EHR/VueCentric
    /// method of logging.  Logging is either on or off, there is no scale from Info to Fatal to
    /// turn off and on.
    /// </summary>
    /// <remarks>
    /// Logging is not heavily used in BMXNET40.  In the EHR/VueCentric, the VIM.exe can be
    /// started on the command-line with the /trace option to see RPC calls.
    /// </remarks>    
    public interface Log
    {
        /// <summary>
        /// True if logging is currently enabled.  It's recommend to turn logging off
        /// except for diagnositics.
        /// </summary>
        bool IsLogging { get; set; }

        /// <summary>
        /// Call to send information to the log.
        /// </summary>
        /// <param name="aClass">A grouping of log entries</param>
        /// <param name="aCategory">A sub-grouping of log entries</param>
        /// <param name="lines">Lines of text to write to the log</param>
        void Log(String aClass, String aCategory, params String[] lines);
        
        /// <summary>
        /// Call to send information to the log where an exception occured.
        /// </summary>
        /// <param name="aClass">A grouping of log entries</param>
        /// <param name="aCategory">A sub-grouping of log entries</param>
        /// <param name="anException">An exception to write to the log</param>
        /// <param name="lines">Lines of text to write to the log</param>
        void Log(String aClass, String aCategory, Exception anException, params String[] lines);
    }
}
